# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 9
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR9_strategy.txt
# LLM Suggested Fallback: D

def benevolent_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate the current round number (1-based index)
    current_round = len(my_history) + 1
    
    # Early game: Build trust with cooperative gestures
    if current_round == 1:
        return "C"  # Initial cooperation to establish goodwill
    elif current_round == 2:
        return "D"  # Strategic testing of opponent's response
    elif current_round == 3:
        return "C"  # Reaffirm cooperation to maintain trust
    
    # Mid-game: Adaptive response based on opponent's behavior
    if 4 <= current_round <= 7:
        if len(opp_history) >= 2 and opp_history[1] == "C":
            return "D"  # Exploit forgiving opponents
        else:
            # Alternate to confuse retaliatory opponents
            return "D" if current_round % 2 == 0 else "C"
    
    # Late-game: Aggressive defection with occasional misdirection
    if current_round >= 8:
        if current_round == 9 and "forgive" in opponent_program_code.lower():
            return "C"  # Fake cooperation to mislead
        else:
            return "D"  # Final defection for maximum gain
    
    # Fallback (shouldn't reach here)
    return "D"